/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8273;

import ibm.nways.jdm.common.ModelInfo;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class IntegerFilter {
    private Vector criteriaVector = new Vector();
    private boolean keepIfAny = false;

    public void addCriteria(String string, int n) {
        IntegerFilterItem integerFilterItem = new IntegerFilterItem(string, n);
        this.criteriaVector.addElement(integerFilterItem);
    }

    public void removeCriteria(String string, int n) {
        IntegerFilterItem integerFilterItem = new IntegerFilterItem(string, n);
        this.criteriaVector.removeElement(integerFilterItem);
    }

    public void setKeepIfAny() {
        this.keepIfAny = true;
    }

    public void setKeepIfAll() {
        this.keepIfAny = false;
    }

    public int getNumberOfCriteria() {
        return this.criteriaVector.size();
    }

    public void filter(Vector vector) {
        Vector<ModelInfo> vector2 = new Vector<ModelInfo>();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                if (this.keepIfAny) {
                    if (this.testIfAnyCriteria(modelInfo)) continue;
                    vector2.addElement(modelInfo);
                    continue;
                }
                if (this.testIfAllCriteria(modelInfo)) continue;
                vector2.addElement(modelInfo);
            }
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                vector.removeElement(enumeration2.nextElement());
            }
        }
    }

    public boolean meetsCriteria(ModelInfo modelInfo) {
        if (this.keepIfAny) {
            return this.testIfAnyCriteria(modelInfo);
        }
        return this.testIfAllCriteria(modelInfo);
    }

    private boolean testIfAnyCriteria(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = this.criteriaVector.elements();
        while (enumeration.hasMoreElements() && !bl) {
            IntegerFilterItem integerFilterItem = (IntegerFilterItem)enumeration.nextElement();
            Serializable serializable = modelInfo.get(integerFilterItem.id);
            if (!(serializable instanceof Integer) || (Integer)serializable != integerFilterItem.intValue) continue;
            bl = true;
        }
        return bl;
    }

    private boolean testIfAllCriteria(ModelInfo modelInfo) {
        boolean bl = true;
        Enumeration enumeration = this.criteriaVector.elements();
        while (enumeration.hasMoreElements() && bl) {
            IntegerFilterItem integerFilterItem = (IntegerFilterItem)enumeration.nextElement();
            Serializable serializable = modelInfo.get(integerFilterItem.id);
            if (serializable instanceof Integer) {
                if ((Integer)serializable == integerFilterItem.intValue) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private class IntegerFilterItem {
        String id;
        int intValue;

        IntegerFilterItem(String string, int n) {
            IntegerFilter.this = IntegerFilter.this;
            this.id = string;
            this.intValue = n;
        }
    }
}

